/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.block;

import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ArcanePedestal;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface IPedestalMachine {
    default public List<BlockPos> pedestalList(BlockPos blockPos, int offset, @NotNull Level level) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos b : BlockPos.betweenClosed((BlockPos)blockPos.offset(offset, -offset, offset), (BlockPos)blockPos.offset(-offset, offset, -offset))) {
            BlockEntity blockEntity = level.getBlockEntity(b);
            if (!(blockEntity instanceof ArcanePedestalTile)) continue;
            ArcanePedestalTile tile = (ArcanePedestalTile)blockEntity;
            posList.add(b.immutable());
        }
        return posList;
    }

    public void lightPedestal(Level var1);

    default public void spawnParticlesForPedestal(Level level, List<BlockPos> pedestalList) {
        for (BlockPos pos : pedestalList) {
            this.spawnParticlesForPedestal(level, pos);
        }
    }

    default public void spawnParticlesForPedestal(Level level, BlockPos pos) {
        BlockState pedestalState = level.getBlockState(pos);
        Block block = pedestalState.getBlock();
        if (!(block instanceof ArcanePedestal)) {
            return;
        }
        ArcanePedestal arcanePedestal = (ArcanePedestal)block;
        Vector3f offsetVec = arcanePedestal.getItemOffset(pedestalState, pos);
        double x = (double)offsetVec.x + ParticleUtil.inRange(-0.3, 0.3);
        double y = (double)offsetVec.y + ParticleUtil.inRange(-0.2, 0.2);
        double z = (double)offsetVec.z + ParticleUtil.inRange(-0.3, 0.3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleOptions type = GlowParticleData.createData(ParticleColor.makeRandomColor(255, 255, 255, level.random), 0.4f, 0.5f, 300);
            serverLevel.sendParticles(type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            ParticleOptions type = GlowParticleData.createData(ParticleColor.makeRandomColor(255, 255, 255, level.random));
            level.addParticle(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

